<?php
namespace MGS\FakeOrder\Model;

use Magento\Catalog\Model\ProductFactory;
use Magento\Store\Model\StoreManagerInterface;

class FakeOrder
{
    protected $productFactory;
    protected $storeManager;

    public function __construct(
        ProductFactory $productFactory,
        StoreManagerInterface $storeManager
    ) {
        $this->productFactory = $productFactory;
        $this->storeManager = $storeManager;
    }

    public function getFakeOrders()
    {
        $productCollection = $this->productFactory->create()->getCollection()
            ->addAttributeToSelect('*')
            ->setPageSize(5)
            ->setCurPage(1)
            ->setOrder('rand()');

        $orders = [];
        foreach ($productCollection as $product) {
            $orders[] = [
                'image' => $this->getImageUrl($product),
                'title' => $product->getName(),
                'url' => $product->getProductUrl(), 
                'location' => $this->getRandomLocation()
            ];
        }

        return $orders;
    }

    private function getImageUrl($product)
    {
        return $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA)
            . 'catalog/product' . $product->getImage();
    }

    private function getRandomLocation()
    {
        $locations = ['New York, USA', 'London, UK', 'Sydney, Australia', 'Tokyo, Japan', 'Berlin, Germany'];
        return $locations[array_rand($locations)];
    }
}
