<?php

namespace MGS\FakeOrder\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use Magento\Catalog\Helper\Image as ImageHelper;

class ProductList implements OptionSourceInterface
{
    protected $productCollectionFactory;
    protected $imageHelper;

    public function __construct(
        CollectionFactory $productCollectionFactory,
        ImageHelper $imageHelper
    ) {
        $this->productCollectionFactory = $productCollectionFactory;
        $this->imageHelper = $imageHelper;
    }

    public function toOptionArray()
    {
        $options = [];
        $collection = $this->productCollectionFactory->create()
            ->addAttributeToSelect(['name', 'thumbnail'])
            ->setPageSize(50);

        foreach ($collection as $product) {
            $imageUrl = $this->imageHelper->init($product, 'product_page_image_small')
                ->setImageFile($product->getSmallImage())
                ->resize(380)
                ->getUrl();
            $options[] = [
                'value'    => $product->getId(),
                'label'    => $product->getName(),
                'image'    => $imageUrl,
                'data-src'    => $imageUrl,
                'url'      => $product->getProductUrl(),
            ];

        }

        return $options;
    }
}
