<?php

namespace MGS\Brand\Ui\Component\Listing\Columns;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use MGS\Brand\Block\Adminhtml\Brand\Grid\Renderer\Action\UrlBuilder;
use Magento\Framework\UrlInterface;

class BrandActions extends Column
{
    const BRAND_URL_PATH_EDIT = 'brand/brand/edit';
    const BRAND_URL_PATH_DELETE = 'brand/brand/delete';
    protected $actionUrlBuilder;
    protected $urlBuilder;
    private $editUrl;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlBuilder $actionUrlBuilder,
        UrlInterface $urlBuilder,
        array $components = [],
        array $data = [],
        $editUrl = self::BRAND_URL_PATH_EDIT
    )
    {
        $this->urlBuilder = $urlBuilder;
        $this->actionUrlBuilder = $actionUrlBuilder;
        $this->editUrl = $editUrl;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $name = $this->getData('name');
                if (isset($item['brand_id'])) {
                    $item[$name]['edit'] = [
                        'href' => $this->urlBuilder->getUrl($this->editUrl, ['brand_id' => $item['brand_id']]),
                        'label' => __('Edit')
                    ];
                    $item[$name]['delete'] = [
                        'href' => $this->urlBuilder->getUrl(self::BRAND_URL_PATH_DELETE, ['brand_id' => $item['brand_id']]),
                        'label' => __('Delete'),
                        'confirm' => [
                            'title' => __(sprintf('Delete  <b>%s</b>',$item['name'])),
                            'message' => __(sprintf('Are you sure you wan\'t to delete a  <b>%s</b> record?',$item['name']))
                        ]
                    ];
                }
            }
        }
        return $dataSource;
    }
}
